<?php
/**
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
 */

class NexiXPayResponse
{

    private $alias;
    private $importo;
    private $divisa;
    private $codTrans;
    private $sessionId;
    private $brand;
    private $nome;
    private $cognome;
    private $mail;
    private $macKey;
    private $mac;
    private $macCalculated;
    private $numContratto;
    private $esito;
    private $data;
    private $orario;
    private $codAut;
    private $pan;
    private $scadenzaPan;
    private $regione;
    private $nazionalita;
    private $messaggio;
    private $hash;
    private $check;
    private $descrizione;
    private $languageId;

    /**
     * @return $this->alias
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * @param alias
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;
    }

    /**
     * @return $this->importo
     */
    public function getImporto()
    {
        return $this->importo;
    }

    /**
     * @param importo
     */
    public function setImporto($importo)
    {
        $this->importo = $importo;
    }

    /**
     * @return $this->divisa
     */
    public function getDivisa()
    {
        return $this->divisa;
    }

    /**
     * @param divisa
     */
    public function setDivisa($divisa)
    {
        $this->divisa = $divisa;
    }

    /**
     * @return $this->codTrans
     */
    public function getCodTrans()
    {
        return $this->codTrans;
    }

    /**
     * @param codTrans
     */
    public function setCodTrans($codTrans)
    {
        $this->codTrans = $codTrans;
    }

    /**
     * @return $this->sessionId
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }

    /**
     * @param sessionId
     */
    public function setSessionId($sessionId)
    {
        $this->sessionId = $sessionId;
    }

    /**
     * @return $this->brand
     */
    public function getBrand()
    {
        return $this->brand;
    }

    /**
     * @param brand
     */
    public function setBrand($brand)
    {
        $this->brand = $brand;
    }

    /**
     * @return $this->nome
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * @param nome
     */
    public function setNome($nome)
    {
        $this->nome = $nome;
    }

    /**
     * @return $this->cognome
     */
    public function getCognome()
    {
        return $this->cognome;
    }

    /**
     * @param cognome
     */
    public function setCognome($cognome)
    {
        $this->cognome = $cognome;
    }

    /**
     * @return $this->mail
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param mail
     */
    public function setMail($mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return $this->macKey
     */
    public function getMacKey()
    {
        return $this->macKey;
    }

    /**
     * @param macKey
     */
    public function setMacKey($macKey)
    {
        $this->macKey = $macKey;
    }

    /**
     * @return $this->mac
     */
    public function getMac()
    {
        return $this->mac;
    }

    /**
     * @param mac
     */
    public function setMac($mac)
    {
        $this->mac = $mac;
    }

    /**
     * @return $this->numContratto
     */
    public function getNumContratto()
    {
        return $this->numContratto;
    }

    /**
     * @param numContratto
     */
    public function setNumContratto($numContratto)
    {
        $this->numContratto = $numContratto;
    }

    /**
     * @return $this->esito
     */
    public function getEsito()
    {
        return $this->esito;
    }

    /**
     * @param esito
     */
    public function setEsito($esito)
    {
        $this->esito = $esito;
    }

    /**
     * @return $this->data
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param data
     */
    public function setData($data)
    {
        $this->data = $data;
    }

    /**
     * @return $this->orario
     */
    public function getOrario()
    {
        return $this->orario;
    }

    /**
     * @param orario
     */
    public function setOrario($orario)
    {
        $this->orario = $orario;
    }

    /**
     * @return $this->codAut
     */
    public function getCodAut()
    {
        return $this->codAut;
    }

    /**
     * @param codAut
     */
    public function setCodAut($codAut)
    {
        $this->codAut = $codAut;
    }

    /**
     * @return $this->pan
     */
    public function getPan()
    {
        return $this->pan;
    }

    /**
     * @param pan
     */
    public function setPan($pan)
    {
        $this->pan = $pan;
    }

    /**
     * @return $this->scadenzaPan
     */
    public function getScadenzaPan()
    {
        return $this->scadenzaPan;
    }

    /**
     * @param scadenzaPan
     */
    public function setScadenzaPan($scadenzaPan)
    {
        $this->scadenzaPan = $scadenzaPan;
    }

    /**
     * @return $this->regione
     */
    public function getRegione()
    {
        return $this->regione;
    }

    /**
     * @param regione
     */
    public function setRegione($regione)
    {
        $this->regione = $regione;
    }

    /**
     * @return $this->nazionalita
     */
    public function getNazionalita()
    {
        return $this->nazionalita;
    }

    /**
     * @param nazionalita
     */
    public function setNazionalita($nazionalita)
    {
        $this->nazionalita = $nazionalita;
    }

    /**
     * @return $this->messaggio
     */
    public function getMessaggio()
    {
        return $this->messaggio;
    }

    /**
     * @param messaggio
     */
    public function setMessaggio($messaggio)
    {
        $this->messaggio = $messaggio;
    }

    /**
     * @return $this->hash
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * @param hash
     */
    public function setHash($hash)
    {
        $this->hash = $hash;
    }

    /**
     * @return $this->check
     */
    public function getCheck()
    {
        return $this->check;
    }

    /**
     * @param check
     */
    public function setCheck($check)
    {
        $this->check = $check;
    }

    /**
     * @return $this->descrizione
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }

    /**
     * @param descrizione
     */
    public function setDescrizione($descrizione)
    {
        $this->descrizione = $descrizione;
    }

    /**
     * @return $this->languageId
     */
    public function getLanguageId()
    {
        return $this->languageId;
    }

    /**
     * @param languageId
     */
    public function setLanguageId($languageId)
    {
        $this->languageId = $languageId;
    }

    /**
     * @return $this->macCalculated
     */
    public function getMacCalculated()
    {
        return $this->macCalculated;
    }

    /**
     * @param macCalculated
     */
    public function setMacCalculated($macCalculated)
    {
        $this->macCalculated = $macCalculated;
    }

    public function calculateMac()
    {
        $toHash = 'codTrans=';

        $toHash .= $this->codTrans;
        $toHash .= 'esito=';
        $toHash .= $this->esito;
        $toHash .= 'importo=';
        $toHash .= $this->importo;

        $toHash .= 'divisa=';
        $toHash .= $this->divisa;

        $toHash .= 'data=';
        $toHash .= $this->data;

        $toHash .= 'orario=';
        $toHash .= $this->orario;

        $toHash .= 'codAut=';
        $toHash .= $this->codAut;

        $toHash .= $this->macKey;

        $this->macCalculated = sha1($toHash);
    }

    public function responseVerified()
    {
        return $this->mac == $this->macCalculated;
    }
}
